window.onload = function() {

    var xhr = new XMLHttpRequest();
    var settings = {
        baseURL: "http://localhost:6080/arcgis/admin",
        token: "", 
        ServiceandFoldername: "",
        ServiceNameinFolder: "",
        status: "",
    };

    //送信データの設定 ※必要に応じて変更します  
    var SendData = {
        username: "siteadmin",
        password: "siteadmin",
        client: "referer",
        referer: location.href,
        expiration: 60,
        f: "pjson"
    }

    //[実行]ボタンの設定 ※必要に応じて変更します  
    var button = document.getElementById("button");
    button.addEventListener("click", GetToken);

    //送信データを URL エンコードする  
    function EncodeHTMLForm() {
        var params = [];
        for (var name in SendData) {
            var value = SendData[name];
            var param = encodeURIComponent(name) + '=' + encodeURIComponent(value);
            params.push(param);
        }
        return params.join('&').replace(/%20/g, '+');
    }

    //トークンを取得する  
    function GetToken() {
        //リクエストが成功した後の動作を設定        
        xhr.onreadystatechange = function() {
            if (xhr.readyState == 4 && xhr.status == 200) {
                //取得したデータを JSON パースし、取得したトークンを既存のオブジェクト settings.token に設定
                settings.token = JSON.parse(xhr.response).token;
            };
        }
        // *****トークン取得 URL へ POST メソッドでリクエストを出す*****
        xhr.open("POST", settings.baseURL + "/generateToken", false);
        xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");　 //リクエストヘッダの設定
        xhr.send(EncodeHTMLForm());　 //データを送信する
        WriteToken();　 //取得したトークンをコンソールへ書き出して終了
    };

    //取得したトークンをコンソールへ書き出す関数
    function WriteToken() {
        console.log("Token:", settings.token)
        GetInfo();
    };

    //ステータスを取得する汎用関数
    function GetStatus(place, consoleIndex) { //引数には動作を行うフォルダー名と、コンソール表示の見出しを設定
        //コンソール表示のグループ化   
        console.group(consoleIndex);
        var i = 0;
        while (i < place.services.length) {　 //サービスの数だけループ

            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    //取得したデータを JSON パースし、既存のオブジェクトに設定
                    settings.status = JSON.parse(xhr.response);
                };
            }

            // フォルダーの有無の確認と open する URL の設定
            if (place.folderName == "/") { // フォルダー名が"/"の場合（ルート フォルダーの場合）
                openURL = settings.baseURL + "/services/" +
                    place.services[i].serviceName + "." +
                    place.services[i].type +
                    "/status?f=pjson&token=" +
                    settings.token
                // ここでは openURL = http://localhost:6080/arcgis/admin/services/<serviceName>.<serviceType>/status?f=pjson&token=<token> となる

            } else {　 // フォルダー名が存在する場合
                openURL = settings.baseURL + "/services/" +
                    place.folderName + "/" +
                    place.services[i].serviceName + "." +
                    place.services[i].type +
                    "/status?f=pjson&token=" +
                    settings.token
                // ここでは openURL = http://localhost:6080/arcgis/admin/services/<FolderName>/<serviceName>.<serviceType>/status?f=pjson&token=<token> となる
            }

            xhr.open("GET", openURL, false); // openURL へ GET メソッドでリクエストを出す
            xhr.send();　　 //データを送信する

            //コンソールに表示
            console.log("ServiceName:",
                place.services[i].serviceName,
                "/ServiceType:",
                place.services[i].type,
                "/configuredState:",
                settings.status.configuredState,
                "/realTimeState:",
                settings.status.realTimeState);

            i++;
        };

        //コンソール表示のグループ化  
        console.groupEnd();
    };

    //services の情報の取得
    function GetInfo() {
        //リクエストが成功した後の動作を設定  
        xhr.onreadystatechange = function() {
            if (xhr.readyState == 4 && xhr.status == 200) {
                //取得したデータを JSON パースし、既存のオブジェクトに設定            
                settings.ServiceandFoldername = JSON.parse(xhr.response);
            };　
        }
        xhr.open("GET", settings.baseURL + "/services?f=pjson&token=" + settings.token, false);　 // GET メソッドでリクエストを出す
        xhr.send();　　 //データを送信する
        checkRoot();　　 //ルート フォルダーでの動作へ
    };

    //ルート フォルダーでの動作
    function checkRoot() {
        //サービスのステータスを取得
        GetStatus(settings.ServiceandFoldername, "Root folder");
        checkFolder(); //個別フォルダー内での動作へ   
    };

    //個別フォルダーについての動作
    function checkFolder() {

        //コンソール表示のグループ化  
        console.group("Folders");

        var j = 0;
        while (j < settings.ServiceandFoldername.folders.length) {　 //フォルダーの数だけループ

            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    //フォルダー内の情報（サービス名）を取得してパース
                    settings.ServiceNameinFolder = JSON.parse(xhr.response);
                };
            }
            xhr.open("GET", settings.baseURL + "/services/" +
                settings.ServiceandFoldername.folders[j] +
                "?f=pjson&token=" + settings.token, false);　 //GET メソッドでリクエストを出す
            xhr.send();　　 //データを送信する

            //サービスのステータス取得
            GetStatus(settings.ServiceNameinFolder, settings.ServiceNameinFolder.folderName);

            j++;
        };

        //コンソール表示のグループ化  
        console.groupEnd();
    };
}