# coding:utf-8
# Purpose : 面積按分を行うツール
#
# Author : ESRIジャパン


# ArcPy サイト パッケージ、os.path モジュールのインポート
import arcpy,os.path
arcpy.env.overwriteOutput = True

# パラメータの設定
inFC = arcpy.GetParameterAsText(0)
refFC = arcpy.GetParameterAsText(1)
Fields = arcpy.GetParameterAsText(2)
outFC = arcpy.GetParameterAsText(3)

# テンポラリ データの作成
arcpy.CopyFeatures_management(refFC,r"in_memory\Copy")
arcpy.AddField_management(r"in_memory\Copy","areaaaaaa","DOUBLE")
arcpy.CalculateField_management("in_memory\Copy","areaaaaaa",'!Shape!.area',"PYTHON_9.3")

sr = arcpy.Describe(inFC).spatialReference
arcpy.CreateFeatureclass_management(os.path.dirname(outFC),os.path.basename(outFC),"POLYGON","","","",sr)

for field in Fields.split(";"):
    arcpy.AddField_management(outFC,field,"DOUBLE")

StaCount = len(Fields.split(";"))
FieldList = ["SHAPE@"] + Fields.split(";")


Cur = arcpy.da.SearchCursor(inFC,["SHAPE@"])
InCur = arcpy.da.InsertCursor(outFC,FieldList)

# 面積按分の実行
for row in Cur:
    geom = row[0]
    arcpy.Clip_analysis("in_memory\Copy",geom,r"in_memory\Clip")
    i = 1
    NewValList = []
    while i < StaCount+1:
        NewVal = 0
        ClipCur = arcpy.da.SearchCursor(r"in_memory\Clip",FieldList + ["areaaaaaa"])
        for ClipRow in ClipCur:
            if ClipRow[i] == None:
                pass
            else:
                NewVal += ClipRow[i] * ClipRow[0].area / ClipRow[-1]
        NewValList.append(NewVal)
        i += 1
    InCur.insertRow([geom] + NewValList)

# テンポラリ データの削除
arcpy.Delete_management(r"in_memory")
del InCur,ClipCur,Cur