# coding:utf-8
# ArcPy サイト パッケージ, os モジュールをインポートします。
import arcpy, os

# 画像形式、解像度、ページ範囲、出力場所を設定します。
outputFormat = arcpy.GetParameterAsText(0)
outputDpi = arcpy.GetParameterAsText(1)
outputPage = arcpy.GetParameterAsText(2)
outputPath = arcpy.GetParameterAsText(3)

# 現在開いているプロジェクトを取得します。
aprx = arcpy.mp.ArcGISProject(r"CURRENT")

# レイアウトを取得します。
l = aprx.listLayouts()[0]

# マップシリーズを取得します。
if not l.mapSeries is None:
    ms = l.mapSeries

# 関数を定義します。
def OutputMS(pageNum):

    try:
        # マップ シリーズの現在のページを設定します。
        ms.currentPageNumber =  pageNum

        # レイアウト名を取得します。
        lytName = l.name

        # 出力ファイルのフルパスを設定します。ファイル名は「レイアウト名_ページ番号」です。
        outputFileName = outputPath + os.sep + lytName + "_" + str(pageNum)

        # BMP 形式で画像を出力します。
        if outputFormat == "BMP":
           l.exportToBMP(outputFileName + ".bmp",  int(outputDpi))

        # EMF 形式で画像を出力します。
        elif outputFormat == "EMF":
           l.exportToEMF(outputFileName + ".emf", int(outputDpi))

        # EPS 形式で画像を出力します。
        elif outputFormat == "EPS":
           l.exportToEPS(outputFileName + ".eps", int(outputDpi))

        # GIF 形式で画像を出力します。
        elif outputFormat == "GIF":
           l.exportToGIF(outputFileName + ".gif", int(outputDpi))

        # JPEG 形式で画像を出力します。
        elif outputFormat == "JPEG":
           l.exportToJPEG(outputFileName + ".jpg", int(outputDpi))

        # PNG 形式で画像を出力します。
        elif outputFormat == "PNG":
           l.exportToPNG(outputFileName + ".png", int(outputDpi))

        # TIFF 形式で画像を出力します。
        elif outputFormat == "TIFF":
           l.exportToTIFF(outputFileName + ".tif", int(outputDpi))

        # フォーマットが適切でない場合はエラーを表示します。
        else:
           arcpy.AddError ("出力フォーマットの設定が適切ではありません")

        arcpy.AddMessage(str(pageNum) + " ページを出力しました。")

    except Exception as e:
        arcpy.AddError(e)
        raise arcpy.ExecuteError

# 各条件ごとにページ番号をリストとして取得し、定義した関数を実行します。
if "," and "-" in outputPage:

    # 文字列から指定したページのリストを取得します。
    outputPageList = outputPage.split(",")
    for item in outputPageList:
        if "-" in item:
            strSplitList = item.split("-")
            intSplitList = []

            # リスト内の文字列型の要素を数値型に変換します。
            for item2 in strSplitList:
                intSplitList.append(int(item2))

            # 指定したページ間のリストを取得して、定義した関数を実行します。
            for pageNum in range(intSplitList[0], intSplitList[1] + 1):
                OutputMS(pageNum)
        else:
            # 定義した関数を実行します。
            OutputMS(item)

elif "," in outputPage:

    # 文字列から指定したページのリストを取得します、
    outputPageList = outputPage.split(",")

    # 定義した関数を実行します。
    for pageNum in outputPageList:
        OutputMS(pageNum)

elif "-" in outputPage:

    # 文字列から指定したページのリストを取得します。
    strSplitList = outputPage.split("-")
    intSplitList = []

    # リスト内の文字列型の要素を数値型に変換します。
    for item in strSplitList:
        intSplitList.append(int(item))

    # 指定したページ間のリストを取得して、定義した関数を実行します。
    for pageNum in range(intSplitList[0], intSplitList[1] + 1):
        OutputMS(pageNum)

elif outputPage == "":

    # すべてのページに対して、定義した関数を実行します。
    for pageNum in range(1, ms.pageCount + 1):
        OutputMS(pageNum)

else:

    # 設定したページ範囲が数値に変換可能な場合に、定義した関数を実行します。
    if outputPage.isdigit() == True:

        # 1 ページのみに対して、定義した関数を実行します。
        OutputMS(int(outputPage))

    else:
        arcpy.AddError("[ページ範囲] パラメーターに設定している文字列が正しくありません。再度確認して実行してください。")
