#coding:cp932
#-------------------------------------------------------------------------------
# Name          : CreateStandardGridSquare
# Purpose:      : Wn惁bV |S쐬c[ (ArcGIS Pro )
#
# Created       : 2018N1210
# Copyright     : ESRIWp
# Disclaimer    : {c[̓Tv vOł肷ׂĂ̓ۏ؂̂ł͂܂B
#                 ESRIWpЂ͖{c[ɂ邢Ȃ鑹Q⏞܂B
#-------------------------------------------------------------------------------
import math
import tempfile
import arcpy
import os

#֐
#-------------------------------------------------------------------------------
#bV쐬p
# MemoryFCName  : o̓ tB[`NX
# Title         : bV
# Width         : bVi\ioܓxj
# Height        : bVi\ioܓxj
# Multiples     : 1bV͈̔͂ɑ΂{
class Grid:
    def __init__(self, level):
        self.MemoryFCName = r"in_memory\grid" + str(level)

        if level == 1:
            self.Title = "1bV"
            self.Width = 1
            self.Height = 2.0 / 3.0
            self.Multiples = 1
        elif level == 2:
            self.Title = "2bV"
            self.Width = 1.0 / 8.0
            self.Height = 2.0 / 3.0 / 8.0
            self.Multiples = 1 * 8
        elif level == 3:
            self.Title = "3bV"
            self.Width = 1.0 / 8.0 / 10.0
            self.Height = 2.0 / 3.0 / 8.0 / 10.0
            self.Multiples = 1 * 8 * 10
        elif level == 4:
            self.Title = "4bV"
            self.Width = 1.0 / 8.0 / 10.0 / 2.0
            self.Height = 2.0 / 3.0 / 8.0 / 10.0 / 2.0
            self.Multiples = 1 * 8 * 10 * 2
        elif level == 5:
            self.Title = "5bV"
            self.Width = 1.0 / 8.0 / 10.0 / 2.0 / 2.0
            self.Height = 2.0 / 3.0 / 8.0 / 10.0 / 2.0 / 2.0
            self.Multiples = 1 * 8 * 10 * 2 * 2
        elif level == 6:
            self.Title = "6bV"
            self.Width = 1.0 / 8.0 / 10.0 / 2.0 / 2.0 / 2.0
            self.Height = 2.0 / 3.0 / 8.0 / 10.0 / 2.0 / 2.0 / 2.0
            self.Multiples = 1 * 8 * 10 * 2 * 2
        elif level == 7:
            self.Title = "100mbVi3bV101וj"
            self.Width = 1.0 / 8.0 / 10.0 / 10.0
            self.Height = 2.0 / 3.0 / 8.0 / 10.0 / 10.0
            self.Multiples = 1 * 8 * 10 * 10
        elif level == 8:
            self.Title = "50mbVi3bV201וj"
            self.Width = 1.0 / 8.0 / 10.0 / 20.0
            self.Height = 2.0 / 3.0 / 8.0 / 10.0 / 20.0
            self.Multiples = 1 * 8 * 10 * 20

#-------------------------------------------------------------------------------
#bV R[h̍쐬
#
# level         : bV x
# lon           : \iox
# lat           : \iܓx
#߂lF^{}
# grid_code     : bVԍ
# grid_code2    : bVԍinCt\Lj
# lon           : [ܓx
# lat           : [ox
def getGridCode(level, lon, lat):
    #1bV
    if level == 1:
        left_operator  = int(math.floor(lat * 15.0 / 10.0))  #ܓx0.667(2/3)x؂
        right_operator = int(math.floor(lon - 100))          #ox1x؂
        dest_lon = right_operator + 100.0
        dest_lat = left_operator * 2.0 / 3.0

        src = {"grid_code":str(left_operator)+str(right_operator),"grid_code2":str(left_operator)+str(right_operator), "lon":dest_lon, "lat":dest_lat}

    #2bV
    elif level == 2:
        base_data = getGridCode(1, lon, lat)

        left_operator = int(math.floor((lat - base_data["lat"]) * 100000.0 / 8333)) #ܓx5(5/60=0.08333)؂
        right_operator = int(math.floor((lon - base_data["lon"]) * 1000.0 / 125.0)) #ox730b(7/60+30/60/60=0.11666+0.008333=0.1249))؂
        dest_lon = right_operator * 125.0 / 1000.0   + base_data["lon"]
        dest_lat = left_operator * 2.0 / 3.0 / 8.0 + base_data["lat"]

        src = {"grid_code":base_data["grid_code"]+str(left_operator)+str(right_operator),"grid_code2":base_data["grid_code"]+"-"+str(left_operator)+str(right_operator), "lon":dest_lon, "lat":dest_lat}

    #3bV
    elif level == 3:
        base_data = getGridCode(2, lon, lat)

        left_operator = int(math.floor((lat - base_data["lat"]) * 1000000.0 / 8333))    #ܓx30b(30/60/60=0.008333)؂
        right_operator = int(math.floor((lon - base_data["lon"]) * 10000.0 / 125.0))    #ox45b(45/60/60=0.0125)؂
        dest_lon = right_operator * 125.0 / 10000 + base_data["lon"]
        dest_lat = left_operator * 2.0/3.0/8.0/10.0 + base_data["lat"]

        src = {"grid_code":base_data["grid_code"]+str(left_operator)+str(right_operator),"grid_code2":base_data["grid_code2"]+"-"+str(left_operator)+str(right_operator), "lon":dest_lon, "lat":dest_lat}

    #4bV
    elif level == 4:
        base_data = getGridCode(3, lon, lat)

        left_operator = int(math.floor((lat - base_data["lat"]) * 1000000.0 / 8333.0 * 2.0))    #ܓx15b(30/60/60/2=0.0041666)؂
        right_operator = int(math.floor((lon - base_data["lon"]) * 10000.0 / 125.0 * 2.0))      #ox22.5b(45/60/60/2=0.00625)؂
        dest_lon = right_operator * 125.0 / 10000 / 2 + base_data["lon"]
        dest_lat = left_operator * 2.0/3.0/8.0/10.0/2.0 + base_data["lat"]

        src = {"grid_code":base_data["grid_code"]+str(getSubCode(left_operator, right_operator)),"grid_code2":base_data["grid_code2"]+"-"+str(getSubCode(left_operator, right_operator)), "lon":dest_lon, "lat":dest_lat}

    #5bV
    elif level == 5:
        base_data = getGridCode(4, lon, lat)

        left_operator = int(math.floor((lat - base_data["lat"]) * 1000000.0 / 8333 * 2 * 2))    #ܓx7.5b(30/60/60/2/2=0.00208333)؂
        right_operator = int(math.floor((lon - base_data["lon"]) * 10000.0 / 125 * 2 * 2))      #ox11.25b(45/60/60/2/2=0.003125)؂
        dest_lon = right_operator * 125.0 / 10000 / 2 / 2 + base_data["lon"]
        dest_lat = left_operator * 2.0/3.0/8.0/10.0/2.0/2.0 + base_data["lat"]

        src = {"grid_code":base_data["grid_code"]+str(getSubCode(left_operator, right_operator)),"grid_code2":base_data["grid_code2"]+"-"+str(getSubCode(left_operator, right_operator)), "lon":dest_lon, "lat":dest_lat}

    #6bV
    elif level == 6:
        base_data = getGridCode(5, lon, lat)

        left_operator = int(math.floor((lat - base_data["lat"]) * 1000000 / 8333.0 * 2 * 2 * 2))    #ܓx 3.75b(30/60/60/2/2/2=0.0010416666)؂
        right_operator = int(math.floor((lon - base_data["lon"]) * 10000 / 125.0 * 2 * 2 * 2))      #ox 5.625b(45/60/60/2/2/2=0.0015625)؂
        dest_lon = right_operator * 125.0 / 10000 / 2 / 2 / 2 + base_data["lon"]
        dest_lat = left_operator * 2.0/3.0/8.0/10.0/2.0/2.0/2.0 + base_data["lat"]

        src = {"grid_code":base_data["grid_code"]+str(getSubCode(left_operator, right_operator)),"grid_code2":base_data["grid_code2"]+"-"+str(getSubCode(left_operator, right_operator)), "lon":dest_lon, "lat":dest_lat}

    #3bV101i100mbVj
    elif level == 7:
        base_data = getGridCode(3, lon, lat) #3bVvZ

        left_operator = int(math.floor((lat - base_data["lat"]) * 1000000 / 8333 * 10))     #ܓx3b(30/60/60/10=0.0008333)؂i3bV1/10j
        right_operator = int(math.floor((lon - base_data["lon"]) * 10000 / 125 * 10))       #ox4.5b(45/60/60/10=0.00125)؂i3bV1/10j
        dest_lon = right_operator * 125.0 / 10000 / 10 + base_data["lon"]
        dest_lat = left_operator * 2.0 / 3.0 / 8.0 / 10.0 / 10.0 + base_data["lat"]

        src = {"grid_code":base_data["grid_code"],"grid_code2":base_data["grid_code2"], "lon":dest_lon, "lat":dest_lat}

    #3bV201i500mbVj
    elif level == 8:
        base_data = getGridCode(3, lon, lat) #3bVvZ

        left_operator = int(math.floor((lat - base_data["lat"]) * 1000000.0 / 8333 * 20))   #ܓx15b(30/60/60/20=0.0041666)؂i3bV1/20j
        right_operator = int(math.floor((lon - base_data["lon"]) * 10000.0 / 125 * 20))     #ox4.5b(45/60/60/20=0.00625)؂i3bV1/20j
        dest_lon = right_operator * 125.0 / 10000 / 20 + base_data["lon"]
        dest_lat = left_operator * 2.0 / 3.0 / 8.0 / 10.0 / 20.0 + base_data["lat"]

        src = {"grid_code":base_data["grid_code"],"grid_code2":base_data["grid_code2"], "lon":dest_lon, "lat":dest_lat}

    return src

#-------------------------------------------------------------------------------
#4`6bVR[hvZp֐
#
# left_operator : R[h
# right_operator: ER[h
#߂l:
# int           : 4`6̃R[hԍ
def getSubCode(left_operator, right_operator):
    if left_operator == 0 and right_operator == 0:
        return 1
    elif left_operator == 0 and right_operator == 1:
        return 2
    elif left_operator == 1 and right_operator == 0:
        return 3
    elif left_operator == 1 and right_operator == 1:
        return 4
    else:
        return None

#-------------------------------------------------------------------------------
#Wn
#
# SpatialReference  : ԎQ
#߂l
# bool              : nWn̏ꍇ͐^AeWn̏ꍇ͋U
def isGCS(SpatialReference):
    if "PROJCS" in SpatialReference.exportToString():
        return False
    else:
        return True

#-------------------------------------------------------------------------------
#WIvZVO̎s
#
# level             : bV x
# min_lon           : bV̓[ܓx
# min_lat           : bV̐[ox
# width             : ̓tB[`NX̕
# height            : ̓tB[`NX̍
# FeatureLayer      : ̓tB[` C
# intersect_featuer : tB[`C^[ZNg邩ǂ
# fieldName         : tB[h
# sr                : ԎQ
#߂l
# Ȃ
def runGP(inGridName,level,min_lon,min_lat,width,height,FeatureLayer,intersect_feature,fieldName,sr):

    arcpy.SetProgressor("default",Grid(level).Title + "쐬Ă܂...")

    gridcode = getGridCode(level, min_lon, min_lat) ##f[^͈̔͂̍ŏ̋`Ō_w
    grid_string = str(gridcode["lon"]) + " " + str(gridcode["lat"])

    if arcpy.Exists(Grid(level).MemoryFCName):
        arcpy.Delete_management(Grid(level).MemoryFCName)

    memory_fc = Grid(level).MemoryFCName

    # ̓tB[`Cgridcodě_܂ŃVtg
    descInFc = arcpy.Describe(FeatureLayer)
    shift_x= descInFc.extent.XMin-gridcode["lon"]
    shift_y= descInFc.extent.YMin-gridcode["lat"]
    # arcpy.AddMessage(str(shift_x)+ "" +str(shift_y)+"ړ܂")
    coordinates = [(gridcode["lon"], gridcode["lat"]),
               (gridcode["lon"], descInFc.extent.YMax-shift_y),
               (descInFc.extent.XMax-shift_x, descInFc.extent.YMax-shift_y),
               (descInFc.extent.XMax-shift_x, gridcode["lat"])]

    shift_fc=arcpy.management.CreateFeatureclass(arcpy.env.scratchGDB,"shiftFC","POLYGON","","DISABLED","DISABLED",descInFc.spatialReference)
    tmp_in_fc = shift_fc[0]
    with arcpy.da.InsertCursor(tmp_in_fc, ['SHAPE@']) as cursor:
        cursor.insertRow([coordinates])


    #bV쐬̍s񐔂vZ
    number_rows = int(math.ceil(height / Grid(level).Height)) + 1
    number_columns = int(math.ceil(width / Grid(level).Width)) + 1

    # CfbNX tB[`̍쐬 (A̎_ł͌_̎w͖ł)
    result = arcpy.GridIndexFeatures_cartography(memory_fc, tmp_in_fc, intersect_feature, "NO_USEPAGEUNIT", "", str(Grid(level).Width) +" DecimalDegrees", str(Grid(level).Height) + " DecimalDegrees", grid_string, str(number_rows), str(number_columns), "1", "NO_LABELFROMORIGIN")

    #tB[h̍폜
    arcpy.DeleteField_management(memory_fc, ["PageName","PageNumber"])

    #tB[h̒ǉ
    arcpy.AddField_management(memory_fc,fieldName[0] , "SHORT")
    arcpy.AddField_management(memory_fc,fieldName[1] , "TEXT")

    # UpdateCursor ֐gp CursorIuWFNg擾
    cursor = arcpy.da.UpdateCursor(memory_fc, ["SHAPE@XY",fieldName[0],fieldName[1]])

    for row in cursor:
        point = row[0]

        meshcode = getGridCode(level, point[0], point[1])
        row[1] = level
        row[2] = meshcode.get("grid_code")
        cursor.updateRow(row)

    #e@̒`
    arcpy.DefineProjection_management(memory_fc,sr)

    #f[^̃Rs[
    fullPath = outWorkspace + "\\" + inGridName[level]
    result = arcpy.CopyFeatures_management(memory_fc, fullPath)
    fc = result.getOutput(0)

##    # intersect_feature ̐ݒɉĕsvȃtB[`폜
##    if intersect_feature== "INTERSECTFEATURE":
##        arcpy.SelectLayerByLocation_management(fc,"CONTAINS",FeatureLayer,None,"NEW_SELECTION","INVERT")
##        arcpy.DeleteFeatures_management (fc)

    del memory_fc,fc

#WIvZVO c[
#-------------------------------------------------------------------------------
#ݒ
arcpy.env.scratchWorkspace = tempfile.gettempdir()  #e|̈̎擾
gcs_fc = arcpy.env.scratchGDB + r"\gcs_fc"          #XNb` [NXy[XptB[`NX

#WIvZVÖ
inFeatureLayer = arcpy.GetParameterAsText(0)        #̓tB[` C
# inIntersected = arcpy.GetParameterAsText(1)         #C^[ZNg邩ǂ
inGrids = arcpy.GetParameterAsText(1)               #쐬bV
outWorkspace = arcpy.GetParameterAsText(2)          #o̓[NXy[X
srName = arcpy.GetParameterAsText(3)                #ԎQ
unlimitedMode = arcpy.GetParameterAsText(4)         #
inGridName = ["dummy"]
inGridName.append(arcpy.GetParameterAsText(5))      #1bVt@C
inGridName.append(arcpy.GetParameterAsText(6))      #2bVt@C
inGridName.append(arcpy.GetParameterAsText(7))      #3bVt@C
inGridName.append(arcpy.GetParameterAsText(8))      #4bVt@C
inGridName.append(arcpy.GetParameterAsText(9))     #5bVt@C
inGridName.append(arcpy.GetParameterAsText(10))     #6bVt@C
inGridName.append(arcpy.GetParameterAsText(11))     #7bVt@C
inGridName.append(arcpy.GetParameterAsText(12))     #8bVt@C

fieldName = ("GRID_LEVEL","GRID_CODE")              #tB[h

try:
    #e@̒`
    if srName == "GCS_JGD_2011":
        sr = arcpy.SpatialReference(104020) #GCS_JGD_2011
    elif srName == "GCS_Tokyo":
        sr = arcpy.SpatialReference(4301)   #GCS_Tokyo
    else:
        sr = arcpy.SpatialReference(4612)   #JGD_2000

    arcpy.env.outputCoordinateSystem = sr   #o͍Wn̐ݒ

##    #̓tB[`ŃC^[ZNg邩ǂ
##    if inIntersected == "false":
##        intersect_feature = "INTERSECTFEATURE"
##    else:
##        intersect_feature = "NO_INTERSECTFEATURE"

    intersect_feature="true"

    # ArcGIS ProɁAȉ̉ӏC
    #fl =arcpy.mapping.Layer(inFeatureLayer)
    fl = inFeatureLayer

    descFL = arcpy.Describe(fl)
    layerSR = descFL.dataElement.spatialReference   #C̋ԎQ

    #Wn̔
    if isGCS(layerSR) == False:
        arcpy.SetProgressor("default","Wn𔻒肵Ă܂...")
        if arcpy.Exists(gcs_fc):
            arcpy.Delete_management(gcs_fc)
        arcpy.Project_management(fl,gcs_fc,sr)
        result = arcpy.MakeFeatureLayer_management(gcs_fc,"new_Layer")
        fl = result.getOutput (0)
        descFL = arcpy.Describe(fl)
        layerSR = descFL.dataElement.spatialReference
        del gcs_fc

    #̓tB[`Əo̓tB[`NX̍Wn̋m
    if layerSR.name != sr.name:
        arcpy.SetProgressor("default","f܂")
        arcpy.AddWarning("tB[`Əo̓tB[`NX̑nnقȂ܂B𒆒f܂B")
        sys.exit()

    # ArcGIS ProɁAȉ̉ӏC
    #extent = fl.getExtent()
    extent=descFL.extent
    inGridsList = inGrids.split(';')

    #~b^
    flugError = False
    extentJapan = arcpy.Extent(122,20,154,46)
    errorMessage = ""

    arcpy.SetProgressor("default","~b^𔻒肵Ă܂...")
    if unlimitedMode == "false":
        #1bV쐬
        if "1bV" in inGridsList and extentJapan.contains(extent) == False:
            errorMessage = "1bV "
            flugError = True
        #2bV̍쐬
        if "2bV" in inGridsList and extentJapan.contains(extent) == False:
            errorMessage = errorMessage + "2bV "
            flugError = True
        #3bV̍쐬
        if "3bV" in inGridsList and (extent.width > 1.1 or extent.height > 0.7):
            errorMessage = errorMessage + "3bV "
            flugError = True
        #4bV̍쐬
        if "4bVi21n惁bVj" in inGridsList and (extent.width > 1.01 or extent.height > 0.7):
            errorMessage = errorMessage + "4bV "
            flugError = True
        #5bV̍쐬
        if "5bVi41n惁bVj" in inGridsList and (extent.width > 1.01 or extent.height > 0.7):
            errorMessage = errorMessage + "5bV "
            flugError = True
        #6bV̍쐬
        if "6bVi81n惁bVj" in inGridsList and (extent.width > 1.01 or extent.height > 0.7):
            errorMessage = errorMessage + "6bV "
            flugError = True
        #100mbVi3bV101וj
        if "100mbVi3bV101וj" in inGridsList and (extent.width > 1.01 / 8.0 or extent.height > 0.67 / 8.0):
            errorMessage = errorMessage + "100mbVi3bV101וj "
            flugError = True
        #50mbVi3bV201וj
        if "50mbVi3bV201וj" in inGridsList and (extent.width > 1.01 / 8.0 or extent.height > 0.67 / 8.0):
            errorMessage = errorMessage + "50mbVi3bV201וj "
            flugError = True

        if flugError == True:
            arcpy.SetProgressor("default","f܂")
            errorMessage = errorMessage + "~b^[͈̔͂𒴂Ă܂B~b^[ɂ菈f܂B"
            arcpy.AddWarning(errorMessage)
            sys.exit()

    #1bV쐬
    if "1bV" in inGridsList:
        runGP(inGridName,1,extent.XMin,extent.YMin,extent.width,extent.height,fl,intersect_feature,fieldName,sr)
    #2bV̍쐬
    if "2bV" in inGridsList:
        runGP(inGridName,2,extent.XMin,extent.YMin,extent.width,extent.height,fl,intersect_feature,fieldName,sr)
    #3bV̍쐬
    if "3bV" in inGridsList:
        runGP(inGridName,3,extent.XMin,extent.YMin,extent.width,extent.height,fl,intersect_feature,fieldName,sr)
    #4bV̍쐬
    if "4bVi21n惁bVj" in inGridsList:
        runGP(inGridName,4,extent.XMin,extent.YMin,extent.width,extent.height,fl,intersect_feature,fieldName,sr)
    #5bV̍쐬
    if "5bVi41n惁bVj" in inGridsList:
        runGP(inGridName,5,extent.XMin,extent.YMin,extent.width,extent.height,fl,intersect_feature,fieldName,sr)
    #6bV̍쐬
    if "6bVi81n惁bVj" in inGridsList:
        runGP(inGridName,6,extent.XMin,extent.YMin,extent.width,extent.height,fl,intersect_feature,fieldName,sr)
    #7bV̍쐬
    if "100mbVi3bV101וj" in inGridsList:
        runGP(inGridName,7,extent.XMin,extent.YMin,extent.width,extent.height,fl,intersect_feature,fieldName,sr)
    #8bV̍쐬
    if "50mbVi3bV201וj" in inGridsList:
        runGP(inGridName,8,extent.XMin,extent.YMin,extent.width,extent.height,fl,intersect_feature,fieldName,sr)

except arcpy.ExecuteError as e:
    arcpy.SetProgressor("default","f܂")
    arcpy.AddError(str(e))
    print (str(e).decode("UTF-8"))