# coding:utf-8
import arcpy

# 入力ポイント
points = arcpy.GetParameterAsText(0)
# 入力ライン
lines = arcpy.GetParameterAsText(1)
# 出力ライン
outFC =  arcpy.GetParameterAsText(2)

try:
    sr = arcpy.Describe(points).spatialReference
    tmp_lines = []

    # いったんラインをディゾルブ
    disso_line =arcpy.Dissolve_management(lines,r"in_memory/disso")
    line_geom = [i[0] for i in arcpy.da.SearchCursor(disso_line,'SHAPE@',spatial_reference=sr)]

    with arcpy.da.SearchCursor(points,'SHAPE@') as cursor:

        # ポイント数分ループ
        for row in cursor:
            end = line_geom[0].queryPointAndDistance(row[0])[0].centroid # ラインの終点座標
            start = row[0].centroid

            tmp_lines.append(arcpy.Polyline(arcpy.Array([start,end]),sr))

except arcpy.ExecuteError:
   arcpy.AddError(arcpy.GetMessages(2))

arcpy.CopyFeatures_management(tmp_lines,outFC)

del disso_line,sr,tmp_lines,cursor,line_geom