# coding:utf-8
# Purpose : アタッチメント テーブルから添付ファイルを抽出します。
# Author : ESRIジャパン


# ArcPy サイト パッケージ、os モジュールをインポートします。
import arcpy, os
from arcpy import da
from os import path

# パラメータを設定します。
inTable = arcpy.GetParameterAsText(0)
inFC =  arcpy.GetParameterAsText(1)
fileLocation = arcpy.GetParameterAsText(2)

# 入力テーブルからパスを取得して、ワークスペースを設定します。
workspacePath = path.dirname(inTable)
arcpy.env.workspace = workspacePath

# 入力テーブルから、テーブル結合に使用するための結合先となるテーブルを取得します。
inTableName = path.basename(inTable)
FeatureClassName =  path.basename(inFC)

# テーブル結合を行うためのデータを作成します。
arcpy.MakeTableView_management(inTable, 'inTableView')
arcpy.MakeFeatureLayer_management(FeatureClassName, 'FeatureLayer')

# テーブル結合
# 必要に応じて、キーの名称を書き換えてください。
arcpy.AddJoin_management('inTableView', 'REL_GLOBALID', 'FeatureLayer', 'GLOBALID', 'KEEP_ALL')

# 結合テーブルから添付ファイルを抽出して出力します。
with da.SearchCursor('inTableView', [inTableName + '.DATA', inTableName + '.ATT_NAME', FeatureClassName + '.OBJECTID']) as cursor:
   for row in cursor:
      binaryRep = row[0]
      fileName = row[1]
      OID = row[2]
      open(fileLocation + os.sep + (str(OID) + '_' + fileName), 'wb').write(binaryRep)
      # オブジェクトの参照を削除し、解放します。
      del row
      del binaryRep
      del fileName
del cursor