#coding:cp932
#-------------------------------------------------------------------------------
# Name:        WIg̃Vtg
# Created:     2013N716
# Copyright:   ESRIWp
#-------------------------------------------------------------------------------
import arcpy
import pythonaddins

try:

    inFC = arcpy.GetParameterAsText(0)              #̓tB[`NX
    outFC = arcpy.GetParameterAsText(1)             #o̓tB[`NX
    shiftX = float(arcpy.GetParameterAsText(2))     #Vtg X Wl
    shiftY = float(arcpy.GetParameterAsText(3))     #Vtg Y Wl

    #tB[`̃Rs[
    arcpy.CopyFeatures_management(inFC,outFC)

    #R[h̃JEg
    record_count = int(arcpy.GetCount_management(inFC).getOutput(0))

    #Progressor ̐ݒ
    arcpy.ResetProgressor()
    arcpy.SetProgressor("step", "tB[`Ă܂...", 1, record_count, 1)

    #tB[` ^CvEWIg ^Cv̎擾
    descFC = arcpy.Describe(outFC)
    featureType = descFC.featureType
    shapeType = descFC.shapeType

    if featureType != "Simple":
        arcpy.AddError("Vv tB[`ȊÕtB[` ^Cv͏ł܂B")
        sys.exit()

    # UpdateCursor ֐gp CursorIuWFNg擾
    cursor = arcpy.da.UpdateCursor(outFC, "SHAPE@")

    # cursor  row IuWFNggpătB[`NX SHAPE tB[h̒lXV
    for row in cursor:
        geometry = row[0]

        #WIg ^CvF|Cg
        if shapeType == "Point":
            point = geometry.getPart(0)
            point.X = point.X + shiftX
            point.Y = point.Y + shiftY
            geometry = arcpy.Point(point.X, point.Y)

        #WIg ^CvF}`|Cg
        elif shapeType == "Multipoint":
            newArray = arcpy.Array()

            for idx in range(geometry.partCount):
                point = geometry.getPart(idx)

                point.X = point.X + shiftX
                point.Y = point.Y + shiftY
                newArray.add(point)

            geometry = arcpy.Multipoint(newArray)

        #WIg ^CvF|CA|S
        elif shapeType == "Polyline" or shapeType == "Polygon":
            newArray = arcpy.Array()

            for idx in range(geometry.partCount):
                part = geometry.getPart(idx)

                newPartArray = arcpy.Array()

                #part(Array ^) None ɂȂ܂Ń[v
                part.reset()
                point = part.next()

                while point != None:
                    point.X = point.X + shiftX
                    point.Y = point.Y + shiftY
                    newPartArray.add(point)

                    point = part.next()

                newArray.add(newPartArray)

            #WIg ^CvF|C
            if shapeType == "Polyline":
                geometry = arcpy.Polyline(newArray)
            #WIg ^CvF|S
            elif shapeType == "Polygon":
                geometry = arcpy.Polygon(newArray)

        #tWIg ^CvF}`pb`
        else:
            arcpy.AddError("̓tB[`NX̃WIg ^Cv͏ł܂B")
            sys.exit()


        #XVWIg̃Zbg
        row[0] = geometry

        #tB[`̃Abvf[g
        cursor.updateRow(row)

        #Xebv
        arcpy.SetProgressorPosition()

    # IuWFNg폜ĎQƂ
    del cursor
    del inFC
    del outFC

    arcpy.AddMessage(str(record_count) + " tB[`܂B")

except arcpy.ExecuteError as e:
    arcpy.AddError(str(e).decode("UTF-8"))
