# coding:shift_jis

import arcpy, os, traceback

def main():

    inputFcLayer        = arcpy.GetParameterAsText(0)   # ̓tB[`C
    outputFcLayer       = arcpy.GetParameterAsText(1)   # o̓tB[`NX
    flagCreateMultipart = arcpy.GetParameter(2)         # }`p[g쐬邩iTrue or Falsej

    try:
        # o̓[NXy[X
        outputWorkspace = os.path.dirname(outputFcLayer)

        # o̓tB[`NX
        outputFcName = os.path.basename(outputFcLayer)


        if flagCreateMultipart:
            arcpy.AddMessage("}`p[g  VOp[g")

            ## }`p[g  VOp[g
            # o͂̓[NXy[Xgp
            result = arcpy.MultipartToSinglepart_management(inputFcLayer, "in_memory\\tempFC")
            inputFcLayer = result.getOutput(0)

        ## Gx[v|S̍쐬
        outputFC = create_envelope_polygon(inputFcLayer, outputWorkspace, outputFcName)

        if flagCreateMultipart:
            arcpy.AddMessage("fB]u")
            ## fB]u
            arcpy.Dissolve_management(outputFC, outputWorkspace + "\\" + outputFcName, ["ORIG_FID"])

        else:
            arcpy.AddMessage("tB[`NX  tB[`NX")
            ## tB[`NX̃Rs[
            arcpy.FeatureClassToFeatureClass_conversion(outputFC, outputWorkspace, outputFcName)

    except:
        ##arcpy.AddError(traceback.format_exc())
        print traceback.format_exc()

    finally:
        arcpy.AddMessage("[NXy[XJ")
        ## [NXy[X̊J
        arcpy.Delete_management("in_memory")



## Gx[v|S̍쐬
def create_envelope_polygon(inputFcLayer, outputWorkspace, outputFcName):

    try:
        # ̓tB[`NX̒`擾
        descinputFcLayer = arcpy.Describe(inputFcLayer)

        # ԎQƂ̎擾
        spRef = descinputFcLayer.spatialReference

        arcpy.AddMessage("tB[`NX쐬")

        ## tB[`NX̍쐬
        # o͂̓[NXy[Xgp
        result = arcpy.CreateFeatureclass_management("in_memory", outputFcName, "POLYGON", inputFcLayer, "DISABLED", "DISABLED", spRef)
        outputFC = result.getOutput(0)

        arcpy.AddMessage("ORIG_FIDtB[hǉ")

        ## tB[h̒ǉ
        arcpy.AddField_management(outputFC, "ORIG_FID", "LONG")

        # R[hꗗ擾
        searchRows = arcpy.SearchCursor(inputFcLayer)
        insertRows = arcpy.InsertCursor(outputFC)

        # FC̃tB[hꗗ擾
        listInputField = arcpy.ListFields(inputFcLayer)

        arcpy.AddMessage("R[hǉ")

        # R[ȟJԂ
        for searchRow in searchRows:

            # R[h̐VK쐬
            newRow = insertRows.newRow()

            ## tB[hl̐ݒ
            set_fieldvalue(newRow, descinputFcLayer, searchRow, listInputField)

            # R[h̒ǉ
            insertRows.insertRow(newRow)

        return outputFC

    finally:
        # bN̉
        if insertRows:
            del insertRows
        if newRow:
            del newRow



## tB[hl̐ݒ
def set_fieldvalue(newRow, descinputFcLayer, searchRow, listInputField):

    # ORIG_FID̐ݒ
    id = searchRow.getValue(descinputFcLayer.OIDFieldName)
    newRow.setValue("ORIG_FID", id)

    for inputField in listInputField:

        # FC̃tB[hl擾
        inputFieldValue = searchRow.getValue(inputField.name)

        if inputField.name == "Shape":

            ## tB[`̃GNXegWIg쐬
            geometry = create_geometry_extent(inputFieldValue)

            # ShapetB[hɃWIgݒ
            newRow.setValue(inputField.name, geometry)

        else:
            if inputField.editable is True:
                newRow.setValue(inputField.name, inputFieldValue)



## tB[`̃GNXegWIg쐬
def create_geometry_extent(inputFieldValue):

    arrayObj = arcpy.Array()

    # GNXeg̎擾
    extent = inputFieldValue.extent

    # Need 5 vertices for square buffer: UpperRight, UpperLeft, LowerLeft, LowerRight, UpperRight.
    arrayObj.add(extent.lowerLeft)
    arrayObj.add(extent.lowerRight)
    arrayObj.add(extent.upperRight)
    arrayObj.add(extent.upperLeft)
    arrayObj.add(extent.lowerLeft)

    # WIg̍쐬
    poly = arcpy.Polygon(arrayObj)

    return poly



if __name__ == '__main__':
    main()
